﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using System.Web.OData;
using System.Web.OData.Routing;
using Microsoft.Xrm.Sdk;
using PpmsDataService.V1.Mappers;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;
using System.Net;
using System.Net.Http;
using Microsoft.Web.Http;

namespace PpmsDataService.V1.Controllers
{
    [EnableQuery]
    // [Authorize]
    [ApiVersion("1.0")]
    public class ProviderAgreementsController : ODataController
    {
        [ODataRoute("ProviderAgreements('{key}')")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string key)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {                
                //Retrieve the Provider Agreement 
                var ppmsProviderAgreement = context.ppms_provideragreementSet.FirstOrDefault(i => i.ppms_agreementid.Contains(key));
                if (ppmsProviderAgreement != null)
                {
                    var ppmsProviderAgreementsList = new List<ppms_provideragreement> { ppmsProviderAgreement };
                    var providerAgreements = await ProviderAgreementsMap.MapProviderAgreements(ppmsProviderAgreementsList, queryType, context);
                    return Request.CreateResponse(providerAgreements);
                }
            }
            var message = string.Format("Provider Agreement with Id: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderAgreements('{key}')/ProviderFacility")]
        public async Task<HttpResponseMessage> GetProviderFacility([FromODataUri] string key)
        {

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Agreement 
                var ppmsProviderAgreement = context.ppms_provideragreementSet.FirstOrDefault(i => i.ppms_agreementid.Contains(key));
                if (ppmsProviderAgreement != null)
                {
                    //Get the Related Provider Facility
                    var ppmsProviderFacility =
                        context.va_facilitySet.FirstOrDefault(i => i.Id == ppmsProviderAgreement.ppms_AssignedFacility.Id);
                    var ppmsProviderFacilityList = new List<va_facility> { ppmsProviderFacility };
                    var providerFacility =
                        await FacilityMap.MapFacilities(ppmsProviderFacilityList, "None", context);
                    return Request.CreateResponse(providerFacility);
                }
            }
            var message = string.Format("Provider Facility with Provider Agreement Id: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        /*
        [ODataRoute("ProviderAgreements('{key}')/CategoryOfCare")]
        public async Task<HttpResponseMessage> GetCategoryOfCare([FromODataUri] string key)
        {

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Agreement 
                var ppmsProviderAgreement = context.ppms_provideragreementSet.FirstOrDefault(i => i.ppms_agreementid.Contains(key));
                if (ppmsProviderAgreement != null)
                {
                    //Get the Related Category of Care
                    var ppmsCategoryOfCare =
                        context.ppms_providertaxonomySet.FirstOrDefault(i => i.Id == ppmsProviderAgreement.ppms_CategoryofCare.Id);
                    var ppmsCategoryOfCareList = new List<ppms_providertaxonomy> { ppmsCategoryOfCare };
                    var categoryOfCare =
                        await ProviderSpecialtyMap.MapProviderSpecialties(ppmsCategoryOfCareList, "None", context);
                    return Request.CreateResponse(categoryOfCare);
                }
            }
            var message = string.Format("Category of Care with Provider Agreement Id: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }
        */

        [ODataRoute("ProviderAgreements('{key}')/AgreementProvider")]
        public async Task<HttpResponseMessage> GetAgreementProvider([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Agreement 
                var ppmsProviderAgreement = context.ppms_provideragreementSet.FirstOrDefault(i => i.ppms_agreementid.Contains(key));
                if (ppmsProviderAgreement != null)
                {
                    //Get the Related Agreement Provider (Provider)
                    var ppmsAgreementProvider =
                        context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderAgreement.ppms_account_ProviderAgreementId.Id);
                    var ppmsAgreementProviderList = new List<Account> { ppmsAgreementProvider };
                    var agreementProvider =
                        await ProviderMap.MapProviders(ppmsAgreementProviderList, "None", context);
                    return Request.CreateResponse(agreementProvider);
                }
            }
            var message = string.Format("Agreement Provider with Provider Agreement Id: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderAgreements('{key}')/AgreementProviders")]
        public async Task<HttpResponseMessage> GetAgreemenProviders([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Agreement 
                var ppmsProviderAgreement = context.ppms_provideragreementSet.FirstOrDefault(i => i.ppms_agreementid.Contains(key));
                if (ppmsProviderAgreement != null)
                {
                    //Get the Related Agreement Providers
                    var ppmsAgreementProviders =
                        context.ppms_agreementproviderSet.Where(i => i.ppms_ProviderAgreement.Id == ppmsProviderAgreement.Id);
                    var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                    var agreementProviders =
                        await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None", context);
                    return Request.CreateResponse(agreementProviders);
                }
            }
            var message = string.Format("Agreement Providers with Provider Agreement Id: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderAgreements('{key}')/ProviderServices")]
        public async Task<HttpResponseMessage> GetProviderServices([FromODataUri] string key)
        {
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                //Retrieve the Provider Agreement 
                var ppmsProviderAgreement = context.ppms_provideragreementSet.FirstOrDefault(i => i.ppms_agreementid.Contains(key));
                if (ppmsProviderAgreement != null)
                {
                    //Get the Related Provider Services
                    var ppmsProviderServices =
                        context.ppms_providerserviceSet.Where(i => i.ppms_ProviderAgreement.Id == ppmsProviderAgreement.Id);
                    var ppmsProviderServicesList = ppmsProviderServices.ToList();
                    var providerServices =
                        await ProviderServicesMap.MapProviderServices(ppmsProviderServicesList, "None", context);
                    return Request.CreateResponse(providerServices);
                }
            }
            var message = string.Format("Provider Services with Provider Agreement Id: {0} not found", key);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ProviderAgreements")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Provider Agreements in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsProviderAgreements = context.ppms_provideragreementSet.Where(i => i.ppms_agreementid != null).Take(50);
                var ppmsProviderAgreementsList = ppmsProviderAgreements.ToList();
                if (ppmsProviderAgreementsList.Any())
                {
                    //Map Provider Agreements
                    var providerAgreements = await ProviderAgreementsMap.MapProviderAgreements(ppmsProviderAgreementsList, "None", context);
                    return Request.CreateResponse(providerAgreements);
                }
                var message = "Provider Agreements Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }       
    }
}